<?php include 'views/layout/header.php'; ?>

<nav class="navbar navbar-expand-lg navbar-light bg-light mb-4 shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">User Panel</a>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=dashboard">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=contacts">Contacts</a></li>
        <li class="nav-item"><a class="nav-link active" href="<?php echo BASE_URL; ?>?page=user&action=template">Template</a></li>
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=birthdays">Today's Birthdays</a></li>
      </ul>
      <a href="<?php echo BASE_URL; ?>?page=auth&action=logout" class="btn btn-outline-danger btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-white">
                <h4>Manage Birthday Template</h4>
            </div>
            <div class="card-body">
                <div class="mb-4 text-center">
                    <h6>Current Template</h6>
                    <?php if (!empty($currentTemplate) && file_exists($currentTemplate)): ?>
                        <!-- Need to fix path for display since $currentTemplate is relative to root file system usually or relative to script execution.
                             It is stored as 'uploads/templates/...' in DB.
                             We can just use ASSETS_URL or direct path if allowed.
                             Using direct relative path from browser if standard setup.
                        -->
                        <img src="<?php echo BASE_URL . $currentTemplate; ?>" class="img-fluid border rounded" style="max-height: 300px;">
                    <?php else: ?>
                        <p class="text-muted">No template uploaded.</p>
                    <?php endif; ?>
                </div>

                <hr>

                <form action="<?php echo BASE_URL; ?>?page=user&action=template" method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label>Upload New Template (JPG/PNG)</label>
                        <input type="file" name="template_image" class="form-control" accept="image/jpeg, image/png" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Template</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'views/layout/footer.php'; ?>
