<?php include 'views/layout/header.php'; ?>

<nav class="navbar navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <span class="navbar-brand mb-0 h1">Admin Panel</span>
    <div>
        <a href="<?php echo BASE_URL; ?>?page=admin&action=dashboard" class="btn btn-secondary btn-sm me-2">Back to Dashboard</a>
        <a href="<?php echo BASE_URL; ?>?page=auth&action=logout" class="btn btn-outline-light btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4>Add New User (msg24.in Integration)</h4>
            </div>
            <div class="card-body">
                <form action="<?php echo BASE_URL; ?>?page=admin&action=add_user" method="POST" enctype="multipart/form-data">

                    <h5 class="mb-3 text-primary">Personal Details</h5>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Full Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Mobile Number</label>
                            <input type="text" name="mobile" class="form-control" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>

                    <hr>
                    <h5 class="mb-3 text-primary">WhatsApp API Details</h5>
                    <div class="mb-3">
                        <label>WhatsApp API URL</label>
                        <input type="text" name="wa_url" class="form-control" value="http://cloudapi.msg24.in/wapp/api/send" required>
                    </div>
                    <div class="mb-3">
                        <label>API Key</label>
                        <input type="text" name="wa_apikey" class="form-control" placeholder="e.g., 0b3b8872febb411e91d76272af225d21" required>
                    </div>

                    <hr>
                    <h5 class="mb-3 text-primary">SMS API Details</h5>
                    <div class="mb-3">
                        <label>SMS API URL</label>
                        <input type="text" name="sms_url" class="form-control" value="http://mysms.msg24.in/api/mt/SendSMS" required>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label>SMS User</label>
                            <input type="text" name="sms_user" class="form-control" placeholder="e.g. LLYADV" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>SMS Password</label>
                            <input type="text" name="sms_password" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Sender ID</label>
                            <input type="text" name="sms_sender_id" class="form-control" placeholder="e.g. ADVOBP" required>
                        </div>
                    </div>

                    <hr>
                    <h5 class="mb-3 text-primary">Birthday Settings</h5>
                    <div class="mb-3">
                        <label>Greeting Message (WhatsApp & SMS)</label>
                        <textarea name="greeting_text" class="form-control" rows="4" required>श्री {NAME} जी आपको जन्मदिवस की हार्दिक शुभकामनाएं।
इस अवसर पर आपकी दीर्घ आयु, अच्छे स्वास्थ्य और मंगल की कामना करता हूँ।
आपका - एडवोकेट एल. एल. यादव (लखन लाल यादव) - अध्यक्ष, इंदौर अभिभाषक संघ</textarea>
                        <small class="text-muted">Use <code>{NAME}</code> as placeholder for the Contact's Name.</small>
                    </div>
                    <div class="mb-3">
                        <label>Upload Template Image (JPG/PNG)</label>
                        <input type="file" name="template_image" class="form-control" accept="image/jpeg, image/png" required>
                    </div>

                    <button type="submit" class="btn btn-success w-100">Create User</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'views/layout/footer.php'; ?>
