<?php
require_once 'config/constants.php';
require_once 'services/MessageService.php';

echo "Verifying Fix (POST & Logging)...\n";

$service = new MessageService(null);

// Mock API Data
$apiData = [
    'wa_url' => 'http://httpbin.org/post', // Echo service to test POST
    'wa_apikey' => 'test_api_key',
    'message' => 'Test Message from Verification Script'
];

$mobile = '919876543210';
$pdfPath = 'uploads/templates/test.pdf'; // Dummy path

echo "Sending Mock WhatsApp Request...\n";
$response = $service->sendWhatsApp($apiData, $mobile, $pdfPath);

echo "Response Status: " . $response['status'] . "\n";
echo "HTTP Code: " . ($response['http_code'] ?? 'N/A') . "\n";

// Check Log File
$logFile = __DIR__ . '/logs/api_requests.log';
if (file_exists($logFile)) {
    echo "Log file exists. Content:\n";
    echo file_get_contents($logFile);
    // clean up log for next run
    unlink($logFile);
} else {
    echo "Log file NOT found!\n";
}
?>
